﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultNetworkPlugin.Controls.Strategy;

namespace WinfootDefaultNetworkPlugin.Controls
{
    public partial class EnableICMPRedirect : UserControl,IControl,ICorrespondenceOS
    {
        private EnableICMPRedirectController enableICMPRedirectController;

        public EnableICMPRedirect()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetEnableCMPRedirectValue(int i)
        {
            switch (i)
            {
                case 0:
                    checkBox1.Checked = false;
                    break;
                case 1:
                    checkBox1.Checked = true;
                    break;
                default:
                    break;
            }
        }


        public int GetDisableIPSourceRoutingValue()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            enableICMPRedirectController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return enableICMPRedirectController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void EnableICMPRedirect_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            enableICMPRedirectController = new EnableICMPRedirectController(this,
                                                                                      (IEnableICMPRedirectStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new EnableICMPRedirectDefaultStrategy()
                                                                                               }));
            enableICMPRedirectController.Read();
        }
    }
}
